﻿//////////////////////////////////////////////
// LogWin.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class ScrollBar ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT LogWin : public Component
	{		
		public :
		
			// Constructor, destructor
			LogWin (System* system) noexcept ;
			virtual ~LogWin () ;

			// Getters
			unsigned int getMaxLine () const ;
			virtual const ScrollBar* getVerticalScrollBar () const ;

			// Setters
			void setMaxLine (unsigned int val) ;

			// Manipulation des lignes
			virtual void addLine (nkMemory::StringView line) ;
			virtual void clear () ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<LogWin> create (System* system = nullptr) ;

		protected :
		
			// Attributs
			// Les lignes et le texte
			nkMemory::BufferCast<nkMemory::String> _lines ;

			// Nombre max de ligne
			unsigned int _maxLine ;

			// L'offset actuel pour s'y retrouver dans le tableau ac' les max lines
			unsigned int _arrayOffset ;

			// La taille d'une ligne en pixels
			unsigned int _lineHeight ;
	} ;
}